# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory.common.cache import cacher
from intranet.yandex_directory.src.yandex_directory import app



VITAL_SERVICES_ERRORS_COUNT_CACHE_KEY = 'vital_services_errors_count'


def reset_errors_count():
    cacher.set(VITAL_SERVICES_ERRORS_COUNT_CACHE_KEY, [])


def get_vital_services_errors_count():
    """
    Возвращает количество ошибок в последних проверках smoke-тестов и число этих проверок
    """
    stats = cacher.get(VITAL_SERVICES_ERRORS_COUNT_CACHE_KEY) or []
    return stats.count(True), len(stats)


def last_smoke_test_has_errors():
    """
    Возвращает статус последней проверки smoke-тестов
    """
    stats = cacher.get(VITAL_SERVICES_ERRORS_COUNT_CACHE_KEY) or []
    if len(stats):
        return stats[-1]
    else:
        return False


def is_need_to_close_service():
    """
    Возвращает признак необходимости закрытия сервиса: True/False
    Определяется количеством сфейлившихся smoke-тестов (BACKPRESSURE_CLOSE_AFTER_ERRORS_COUNT)
    за определенное количество проверок (BACKPRESSURE_CHECK_WINDOW_SIZE)
    """
    smoke_test_results, smoke_tests_count = get_vital_services_errors_count()

    # если мы число проверок smoke-тестов достигло BACKPRESSURE_CHECK_WINDOW_SIZE
    # и при этом число ошибок >= BACKPRESSURE_CLOSE_AFTER_ERRORS_COUNT
    # вернем True
    if (
        smoke_test_results >= app.config['BACKPRESSURE_CLOSE_AFTER_ERRORS_COUNT'] and
        app.config['BACKPRESSURE_CHECK_WINDOW_SIZE'] == smoke_tests_count
    ):
        with log.fields(smoke_tests_errors_count=smoke_test_results):
            log.error('Critical smoke tests errors count!')
        return True
    else:
        return False


def save_smoke_results(has_errors):
    if has_errors:
        with log.fields(has_errors=has_errors):
            log.info(
                'Saving vital services errors status: we HAVE errors'
            )
    smoke_test_results = cacher.get(VITAL_SERVICES_ERRORS_COUNT_CACHE_KEY) or []

    smoke_test_results.append(has_errors)

    while len(smoke_test_results) > app.config['BACKPRESSURE_CHECK_WINDOW_SIZE']:
        smoke_test_results.pop(0)
    cacher.set(VITAL_SERVICES_ERRORS_COUNT_CACHE_KEY, smoke_test_results)
