import urllib
import requests

from intranet.yandex_directory.src import settings

from intranet.yandex_directory.src.yandex_directory.auth import tvm
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log
from intranet.yandex_directory.src.yandex_directory.common import http_client


class BillingInvoiceApiException(Exception):
    pass


class BillingInvoiceClient(object):
    def __init__(self):
        self.base_url = settings.BILLING_INVOICE_API_URL
        self.timeout = 5

    def get_invoice_data(self, invoice_id):
        url = urllib.parse.urljoin(self.base_url, f'documents/invoices/{invoice_id}')
        headers = {
            'X-Ya-Service-Ticket': tvm.tickets['billing_invoice'],
        }

        response = http_client.request(
            'get',
            url=url,
            headers=headers
        )
        try:
            response.raise_for_status()
        except requests.exceptions.HTTPError:
            with log.fields(
                    response_status_code=response.status_code,
                    response_text=response.text,
            ):
                log.warning('Billing invoice api error acquired')
                raise BillingInvoiceApiException()

        return response.json()
