# -*- coding: utf-8 -*-
import random

from unittest.mock import Mock

from intranet.yandex_directory.src.yandex_directory.common.billing.client import BillingClient


class MockBillingClient(BillingClient):
    def __init__(self, endpoint, token, manager_uid):
        self.endpoint = endpoint
        self.token = token
        self.manager_uid = manager_uid

        self.server = Mock()
        self.server.Balance.CreateClient = lambda *args, **kwargs: (None, None, random.randint(1, 1000000))
        self.server.Balance.CreatePerson = lambda *args, **kwargs: random.randint(1, 1000000)
        contract_info = {
            'EXTERNAL_ID': '%s/17' % random.randint(1, 1000000),
            'ID': random.randint(1, 1000000),
        }
        self.server.Balance.CreateOffer = lambda *args, **kwargs: contract_info
