# -*- coding: utf-8 -*-
import pickle

from cachetools import TTLCache, cached
from cachetools.keys import hashkey
from threading import RLock

from intranet.yandex_directory.src.yandex_directory import app

# TODO: этот класс нигде кроме тестов не используется, его можно выпилить
class UwsgiCache(object):
    # префикс для всех ключей чтобы не пересекаться с другими данными в кэше,
    # например данными для статистики golovan
    _cache_key_prefix = 'dir_cacher'

    def __init__(self):
        import uwsgi
        self.uwsgi = uwsgi

    def set(self, key, value):
        return self.uwsgi.cache_set(
            self._generate_key(key), pickle.dumps(value)
        )

    def get(self, key):
        try:
            pickle.loads(
                self.uwsgi.cache_get(
                    self._generate_key(key)
                )
            )
        except (IndexError, TypeError):
            return None

    def _generate_key(self, key):
        return '%s_%s' % (self._cache_key_prefix, key)


class SimpleCache(object):
    _cache = {}

    def set(self, key, value):
        self._cache[key] = value

    def get(self, key):
        return self._cache.get(key)


try:
    cacher = UwsgiCache()
except ImportError:
    cacher = SimpleCache()



def cached_in_memory_with_ttl(ttl, max_size=1000, key=hashkey):
    """Декоратор, который кэширует в памяти процесса результат выполнения функции на заданное количество секунд.
    """
    cache_size = 0 if app.testing else max_size
    cache = TTLCache(maxsize=cache_size, ttl=ttl)
    lock = RLock()

    def decorator(func):
        return cached(cache, lock=lock, key=key)(func)
    return decorator
