# encoding: UTF-8

import hashlib
import pickle


def make_key(prefix, key_data, hash=hashlib.sha1):
    # HIGHEST_PROTOCOL - обеспечивает наибольшую производительность
    serialized = pickle.dumps(
        key_data,
        protocol=pickle.HIGHEST_PROTOCOL
    )
    key = '%s:%s' % (prefix, hash(serialized).hexdigest())

    assert len(key) <= 250, 'Key too long'

    return key
