# -*- coding: utf-8 -*-
import pprint
import subprocess
import os

from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option
from intranet.yandex_directory.src.yandex_directory.common import db


def pretty_print(data, indent=0):
    indent_string = ' ' * indent

    if isinstance(data, dict):
        for key, value in sorted(data.items()):
            if isinstance(key, int):
                # интами у нас обозначаются шарды,
                # поэтому выведем их более красиво
                print('{0}shard {1}'.format(indent_string, key))
            else:
                print(indent_string + str(key))
            pretty_print(value, indent + 4)
    elif isinstance(data, list):
        for item in data:
            # тут выводятся енджины, заодно выведем информацию о том,
            # кто из них жив
            print('{0}- {1}, is_alive={2}'.format(
                indent_string,
                item,
                item.db_info['is_alive'],
            ))
    else:
        print(str(data))


class Command(BaseCommand):
    """
    Войти в shard 2 на main базе для чтения и записи: dbshell -d main -r master -s 2
    Войти в метабазу только для чтения: dbshell -d meta -r replica
    """
    name = 'dbshell'
    option_list = (
        Option('--db_alias', '-d', dest='db_alias'),
        Option('--role', '-r', dest='role'),
        Option('--shard', '-s', dest='shard', type=int),
        Option('--host', '-h', dest='host'),
        Option('--info', '-i', dest='info', type=bool),
    )

    def run(self, db_alias, role=None, shard=None, host=None, info=None):
        data = db.engines
        level = 'aliases'

        # а теперь пробуем отфильтровать коннекты по заданным критериям
        if db_alias:
            data = data[db_alias]
            level = 'shards'

            # поскольку в метабазе только один шард,
            # то задавать его явно не обязательно
            if db_alias == 'meta' and not shard:
                shard = 1

            if len(data) == 1:
                # если шард всего один, то не требуем, чтобы его явно указывали
                data = list(data.values())[0]
                level = 'roles'
            elif shard:
                data = data[shard]
                level = 'roles'

            if level == 'roles' and role:
                data = data[role]
                level = 'engines'

                if host:
                    data = [engine for engine in data if engine.db_info['host'] == host]

        if data:
            if info:
                pprint.pprint(data)
                return

            if level == 'engines':
                engine = data
            else:
                print('Can\'t connect to more than one databases.')
                print('Please specify additional filters.')
                pretty_print(data)
                return
        else:
            print('Connection not found')
            return

        print('Connecting to %s' % db.get_secure_dsn_for(engine))

        pgshell = os.environ.get('PGSHELL', 'psql')

        db_settings = db.get_connection_info_for(engine)
        command = ''

        if db_settings.get('password'):
            command = 'PGPASSWORD={password} '.format(
                password=db_settings.get('password'))

        if role == 'master':
            target_session_attrs_opt = 'target_session_attrs=read-write'
        else:
            target_session_attrs_opt = ''

        command += (
            '{pgshell} -d "'
            'host={host} '
            'port={port} '
            'sslmode=verify-full '
            'dbname={database} '
            'user={user} '
            '{target_session_attrs_opt}"'
        ).format(
            pgshell=pgshell,
            target_session_attrs_opt=target_session_attrs_opt,
            **db_settings
        )
        subprocess.call(command, shell=True)
