# -*- coding: utf-8 -*-
import json

from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option

# Как формировать запросы https://yandextank.readthedocs.io/en/latest/tutorial.html#request-style


BASE_HEADERS = {
    'Accept': 'application/json',
    'User-Agent': 'Yandex Tank',
    'Host': 'api.stress.portal.ws.yandex.ru',
    'X-Forwarded-For': '127.0.0.1'
}


def generate_ammo(requests, output):
    """
    Генерирует патроны для стрельбы вида:
        73 good
        GET / HTTP/1.1
        Host: xxx.tanks.example.com
        User-Agent: xxx (shell 1)

    На входе получает итератор по входным данным
    и файловый объект куда их писать.
    """
    for request in requests:
        result = _get_request_text(request)
        output.write(result)



def _get_request_text(request):
    headers = BASE_HEADERS.copy()
    if 'headers' in request:
        headers.update(request['headers'])
    request['headers'] = headers

    request_text = '{method} {uri} HTTP/1.1\r\n'.format(method=request['method'], uri=request['uri'])

    # headers
    def generate_headers(headers):
        return ['%s: %s' % (header_name.title(), value) for header_name, value in list(headers.items())]

    request_text += '\r\n'.join(generate_headers(request['headers']))
    request_text += '\r\n' * 2

    # body
    if 'body' in request:
        if not isinstance(request['body'], str):
            request['body'] = json.dumps(request['body'])
        request_text += request['body']
        request_text += '\r\n'

    # length
    request_text = request_text.encode('utf-8')
    length = len(request_text)

    # tag
    request_tag = request.get('tag')
    if request_tag:
        request_tag = ' ' + request_tag
    else:
        request_tag = ''

    return '{length}{request_tag}\n{request_text}'.format(
        length=length,
        request_tag=request_tag,
        request_text=request_text,
    )


class Command(BaseCommand):
    """
    Формирует патроны для танка, на основе входного json файла вида:

        {
            "method": "GET",
            "uri": "/",
            "headers": {
                "Authorization": "token dsJdfdfdsadsaGH67b",
                "X-UID": 19308334909853078,
                "X-User-IP": "127.0.0.1"
            }
        }

    Только каждый такой словарик должен занимать ровно одну строчку во
    входном файле.
    """
    name = 'generate-ammo'
    option_list = (
        Option('--source', '-s', dest='source', required=False),
        Option('--output', '-o', dest='output', required=True),
    )

    def run(self, source, output):
        with open(output, 'w') as f:
            requests = self._get_requests(source)
            generate_ammo(requests, f)

    def _get_requests(self, source):
        if source:
            with open(source) as f:

                # прежний вариант читал и парсил всё содержимое файла целиком
                # text = f.read().decode('utf-8')
                # # удалим из текста все комментарии
                # text = re.sub(
                #     ur'^ *\#.*',
                #     '',
                #     text,
                #     flags=re.MULTILINE | re.UNICODE
                # )
                # requests = json.loads(text)

                for line in f:
                    line = line.strip()
                    line = line.strip(',')
                    try:
                        request = json.loads(line)
                        yield request
                    except Exception:
                        print('Skipping', line)
                        pass
        else:
            # default request
            yield {
                'method': 'GET',
                'uri': '/',
                'tag': 'root',
            }
