# -*- coding: utf-8 -*-
import json

from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option

# Как формировать запросы https://yandextank.readthedocs.io/en/latest/tutorial.html#request-style


BASE_HEADERS = {
    'accept': 'application/json',
    'host': 'api.stress.portal.ws.yandex.ru',
    'user-agent': 'xxx (shell 1)',
    'X-Forwarded-For': '127.0.0.1'
}


def generate_ammo(requests):
    """
    Генерирует патроны для стрельбы вида:
        73 good
        GET / HTTP/1.1
        Host: portal-stress.ws.yandex.ru
        User-Agent: xxx (shell 1)
    """
    return ''.join(map(_get_request_text, requests))


def _get_request_text(request):
    headers = BASE_HEADERS.copy()
    if 'headers' in request:
        headers.update(request['headers'])
    request['headers'] = headers

    request_text = '{method} {uri} HTTP/1.1\r\n'.format(method=request['method'], uri=request['uri'])

    # headers
    def generate_headers(headers):
        return ['%s: %s' % (header_name.title(), value) for header_name, value in list(headers.items())]

    request_text += '\r\n'.join(generate_headers(request['headers']))
    request_text += '\r\n' * 2

    # body
    if 'body' in request:
        if not isinstance(request['body'], str):
            request['body'] = json.dumps(request['body'])
        request_text += request['body']
        request_text += '\r\n'

    # length
    request_text = request_text.encode('utf-8')
    length = len(request_text)

    # tag
    request_tag = request.get('tag')
    if request_tag:
        request_tag = ' ' + request_tag
    else:
        request_tag = ''

    return '{length}{request_tag}\n{request_text}'.format(
        length=length,
        request_tag=request_tag,
        request_text=request_text,
    )


class Command(BaseCommand):
    """
    Формирует патроны для танка, на основе входного json файла вида:

    [
        {
            "method": "GET",
            "uri": "/",
            "headers":  {
                'Cookie': 'Session_id=3:1471459927.5.2.1471256565000:IHEGG-w_wRQMBAAAuAYCKg:26.1|75671288.0.2|1130000021480572.18329.2.2:18329|1130000021421956.203362.2.2:203362|150231.109666.ce3WIInRTwoNe5ZLh7G4zX5mWio; sessionid2=3:1471459927.5.0.1471256565000:IHEGG-w_wRQMBAAAuAYCKg:26.1|75671288.0.2|1130000021480572.18329.2.2:18329|1130000021421956.203362.2.2:203362|150231.485689.3wFVtCTXTFytsMsAzAHuRrnYzFo',
                'x-org-id': 7042,
            }
        },...
    ]
    """
    name = 'generate-ammo-portal'

    option_list = (
        Option('--source', '-s', dest='source', required=False),
        Option('--output', '-o', dest='output', required=True),
    )

    def run(self, source, output):
        with open(output, 'w') as f:
            f.write(generate_ammo(self._get_requests(source)))

    def _get_requests(self, source):
        if source:
            with open(source) as f:
                requests = json.loads(f.read().decode('utf-8'))
        else:
            requests = self._get_default_requests()
        return requests

    def _get_default_requests(self):
        return [
            {
                'method': 'GET',
                'uri': '/',
                'tag': 'root',
            }
        ]
