# -*- coding: utf-8 -*-
import sys

from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand
from intranet.yandex_directory.src.yandex_directory import app


class Command(BaseCommand):
    name = 'runserver'

    def run(self):
        port = app.config['PORT']
        user = app.config['CURRENT_USER']

        if not port:
            print((
                'Please, choose port to run devserver and add '
                'PORT=???? line to "src/env_settings/{0}.py"'
            ).format(user))
            sys.exit(1)

        print("Starting dev server for {0} on port {1}".format(
            user,
            port,
        ))

        app.run(
            debug=app.config['DEBUG'],
            threaded=True,
            host='::',
            port=port,
        )
