# coding: utf-8

from intranet.yandex_directory.src import settings
from intranet.yandex_directory.src import blackbox_client

from flask_script.commands import Shell
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_main_connection,
    get_meta_connection,
    get_shard_numbers,
    get_shard,
)
from intranet.yandex_directory.src.yandex_directory.common.models.base import BaseModel
from intranet.yandex_directory.src.yandex_directory.core import models
from intranet.yandex_directory.src.yandex_directory.core.permission.permissions import get_permissions
from inspect import ismodule
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    is_outer_uid,
    get_user_info_from_blackbox,
    get_user_data_from_blackbox_by_login,
    get_user_data_from_blackbox_by_uid,
    get_user_data_from_blackbox_by_uids,
    get_user_id_from_passport_by_login,
)
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.core.tasks import SyncExternalIDS
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    get_domain_info_from_blackbox,
    get_account_list_from_blackbox,
    get_suid_from_blackbox_for_uid,
    create_domain_in_passport,
)


class Command(Shell):
    name = 'shell'

    def get_context(self):
        meta_connection_manager = get_meta_connection()
        meta_connection = meta_connection_manager.__enter__()
        context = {
            'get_shard_numbers': get_shard_numbers,
            'meta_connection': meta_connection,
            'mo': models.OrganizationMetaModel(meta_connection),
            'mu': models.UserMetaModel(meta_connection),
            'main_connection': None,
            # Нам нужно сохранять контекстные менеджеры, чтобы
            # GC не собрал их и не отдал коннекты обратно в пул.
            '_main_connection_context_manager': None,
            '_meta_connection_context_manager': meta_connection_manager,
            'meta': get_meta_connection,
            'main': get_main_connection,
        }

        for func in (
            get_main_connection,
            get_meta_connection,
            get_shard,
            get_domain_info_from_blackbox,
            get_account_list_from_blackbox,
            get_suid_from_blackbox_for_uid,
            create_domain_in_passport,
            get_user_info_from_blackbox,
            get_user_data_from_blackbox_by_login,
            get_user_data_from_blackbox_by_uid,
            get_user_data_from_blackbox_by_uids,
            get_user_id_from_passport_by_login,
            SyncExternalIDS,
        ):
            context[func.__name__] = func


        def silent_is_subclass(cls1, cls2):
            try:
                return issubclass(cls1, cls2)
            except:
                pass

        # сделаем доступными все модели
        context.update(
            (key, value)
            for key, value in list(models.__dict__.items())
            if ismodule(value) or silent_is_subclass(value, BaseModel)
        )

        def use_shard(shard, silent=False, for_write=False):
            """Этот хелпер переключает шард, меняя глобальную переменную main_connection.
            """
            if not silent:
                print('Switching to shard {0}'.format(shard))

            old_mgr = context['_main_connection_context_manager']
            if old_mgr:
                old_mgr.__exit__(None, None, None)

            mgr = get_main_connection(shard, for_write=for_write)
            main_connection = mgr.__enter__()
            context['_main_connection_context_manager'] = mgr
            context['main_connection'] = main_connection

            models_map = (
                ('u', models.UserModel),
                ('dep', models.DepartmentModel),
                ('g', models.GroupModel),
                ('o', models.OrganizationModel),
                ('dom', models.DomainModel),
                ('a', models.ActionModel),
                ('e', models.EventModel),
                ('r', models.ResourceModel),
            )
            for var_name, model in models_map:
                context[var_name] = model(main_connection)

            context['current_shard'] = shard


        def iterate_over_organizations():
            """Возвращает iterable, при итерации по которому происходит переключение главной базы с шарда на шард.

            А сам iterable возвращает id организаций. Так он перебирает все шарды и все организации, что удобно
            для выполнения каких-либо действий над организацией."""
            shards = get_shard_numbers()
            saved_shard = context['current_shard']

            try:
                for shard in shards:
                    use_shard(shard, silent=True)
                    orgs = context['o'].find()
                    for org in orgs:
                        yield org['id']
            finally:
                # когда всё закончилось, нужно переключиться обратно на тот шард, что была
                use_shard(saved_shard, silent=True)

        def get_uid(login_or_uid):
            """Возвращает uid по логину или уиду."""

            uid = app.blackbox_instance.uid(login_or_uid)
            if not uid:
                # если блэкбокс логин не распознал, то может быть нам передали uid?
                try:
                    return int(login_or_uid)
                except ValueError:
                    pass
                raise RuntimeError('Unknown login: {0}'.format(login_or_uid))

            return uid

        def make_outer_admin(outer_login, inner_login):
            """Делает учётку с outer_login внешним админом в организации, в которой состоит вторая учётка."""
            outer_uid = get_uid(outer_login)

            if not is_outer_uid(outer_uid):
                raise AssertionError('Пользователь должен быть внешним')

            inner_uid = get_uid(inner_login)
            inner_user = context['mu'].get(inner_uid)
            org_id = inner_user['org_id']
            # создадим в метабазе запись про пользователя
            # то, что он внешний, модель поймёт сама
            return context['mu'].create(outer_uid, org_id)

        def check_permissions(org_id,
                              uid,
                              domain=None,
                              object_type=None,
                              object_id=None):
            """Проверяет список пермишшенов для пользователя.
               А так же выдаёт значения предикатов, полученных в ходе проверки.
            """
            shard = get_shard(context['meta_connection'], org_id)
            if shard != context['current_shard']:
                use_shard(shard)

            cache = {}
            permissions = get_permissions(
                context['meta_connection'],
                context['main_connection'],
                uid,
                object_type=object_type,
                object_id=object_id,
                org_id=org_id,
                cache=cache,
            )
            return {
                'predicates': cache,
                'permissions': permissions,
            }


        context['app'] = app
        context['use_shard'] = use_shard
        context['get_uid'] = get_uid
        context['make_outer_admin'] = make_outer_admin
        context['iterate_over_organizations'] = iterate_over_organizations
        context['check_permissions'] = check_permissions
        shards = get_shard_numbers()
        use_shard(shards[0])
        return context
