# encoding: UTF-8

from flask import current_app
from flask import Flask
from typing import Any
from typing import Optional


class ComponentRegistry(object):
    pass


def component_registry(app=None):
    # type: (Optional[Flask]) -> Any

    if app is None:
        app = current_app

    try:
        return getattr(app, 'components')
    except AttributeError:
        components = ComponentRegistry()
        setattr(app, 'components', components)
        return components
