# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.utils import raise_for_status


class ConductorClientBase(object):
    def __init__(self, url):
        self.url = url

    def add_group(self, group_name, data):
        raise NotImplementedError()

    def add_host(self, fqdn, group_name, data):
        raise NotImplementedError()

    def hosts_by_group(self, group_name):
        response = self._hosts_by_group(group_name)
        raise_for_status(response)
        return [
            i['fqdn'] for i in response.json()
        ]

    def _hosts_by_group(self, group_name):
        raise NotImplementedError()
