# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.conductor.base import ConductorClientBase
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    url_join,
)


class ConductorClient(ConductorClientBase):
    """
    https://github.yandex-team.ru/common-python/conductor/blob/master/conductor.py
    """
    def _hosts_by_group(self, group_name):
        url = url_join(
            self.url,
            'groups2hosts/' + group_name,
            query_params={
                'format': 'json'
            }
        )
        return app.requests.get(
            url=url,
            headers={
                'content-type': 'application/json'
            },
            timeout=(3, None)
        )
