# -*- coding: utf-8 -*-
from threading import local

from requests import Response

from intranet.yandex_directory.src.yandex_directory.common.conductor.base import ConductorClientBase


CONDUCTOR_DATA = local()


def clear_conductor_data():
    CONDUCTOR_DATA.groups = {}
    CONDUCTOR_DATA.hosts = {}
    CONDUCTOR_DATA.hosts_by_group = {}


clear_conductor_data()


class ConductorMockClient(ConductorClientBase):
    def add_group(self, group_name, data):
        CONDUCTOR_DATA.groups[group_name] = data

    def add_host(self, fqdn, group_name, data):
        CONDUCTOR_DATA.hosts[fqdn] = data
        CONDUCTOR_DATA.hosts_by_group.setdefault(group_name, []).append(data)

    def _hosts_by_group(self, group_name):
        return [
            {'fqdn': i['fqdn']} for i in CONDUCTOR_DATA.hosts_by_group[group_name]
        ]
