from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.db import get_meta_connection
from intranet.yandex_directory.src.yandex_directory.core.models import (
    OrganizationModel,
    DomainModel,
    OrganizationMetaModel,
)
from intranet.yandex_directory.src.yandex_directory.common.models.types import TYPE_DOMAIN
from intranet.yandex_directory.src.yandex_directory.core.models.action import ActionModel
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    get_domain_info_from_blackbox,
    create_domain_in_passport,
)

"""
Этот файл предсавляет собой набор хаков, которые мы сделали для фикса
более менее массовых проблем, в которых нам не удалось найти настоящие
причины рассинхронна данных и мы написали костыли ниже
"""


def sync_master_domain(main_connection, master_domain, org_id):
    """
    Вызывается когда у нас домен помечен как мастер, а в паспорте
    такого нет - в этом случае смотрим удалялся ли домен по actions
    у нас, если удалялся - удаляем из базы, если нет - создаем в паспорте
    """
    was_deleted = False
    actions = ActionModel(main_connection).filter(
        org_id=org_id,
        name="domain_delete",
        object_type=TYPE_DOMAIN,
    )
    for action in actions:
        if action['object']['name'] == master_domain:
            was_deleted = True
            break

    if was_deleted:
        DomainModel(main_connection).delete(
            filter_data={'name': master_domain, 'org_id': org_id},
            force_remove_all=True,
            delete_blocked=True,
        )

    else:
        admin_uid = OrganizationModel(main_connection).get(org_id)['admin_uid']
        create_domain_in_passport(main_connection, org_id, master_domain, admin_uid)


def sync_domain_status(main_connection, domain, org_id):
    """
    У нас в базе домен - мастер, а в паспорте алиас
    Нужно проверить относится ли паспортный мастер к текущей организации,
    если относится - делаем наш мастер мастером в паспорте
    """

    alias_info = get_domain_info_from_blackbox(domain)
    if alias_info['master_domain']:
        passport_master_in_org = DomainModel(main_connection).filter(
            org_id=org_id,
            name=alias_info['master_domain'],
            owned=True,
        ).one()
        if passport_master_in_org:
            master_info = get_domain_info_from_blackbox(alias_info['master_domain'])
            return app.passport.set_master_domain(master_info['domain_id'], alias_info['domain_id'])
