# encoding: UTF-8

from typing import Any
from typing import Dict
from typing import Mapping
from typing import Sequence


def flatten(d, sep='.'):
    # type: (Mapping[str, Any], str) -> Dict[str, Any]
    """
    Делает плоским словарь со вложеными словарями.
    """
    result = {}
    for key, value in d.items():
        if isinstance(value, Mapping):
            for nested_key, nested_value in flatten(value).items():
                result[key + sep + nested_key] = nested_value
        else:
            result[key] = value
    return result


def flatten_lists(lst):
    """
    Принимает на вход список списков, обходит их в глубину
    и возвращает плоский список из конечных элементов.

    Например:

    flatten_lists([1, 2, [100, 500, [600]], 3, 4])

    вернёт:

    [1, 2, 100, 500, 600, 3, 4]
    """
    def rec(lst):
        if lst:
            if isinstance(lst[0], list):
                for item in rec(lst[0]):
                    yield item
            else:
                yield lst[0]

            for item in rec(lst[1:]):
                yield item

    return list(rec(lst))


def unwrap_single_item(l):
    # type: (Any) -> Any
    """
    Если список состоит из одного элемента, то возвращает этот элемент.
    Иначе возвращает список без изменений.
    """
    if isinstance(l, Sequence) and len(l) == 1:
        return l[0]
    else:
        return l
