# encoding: UTF-8

from abc import ABCMeta
from abc import abstractmethod

from flask import current_app
from flask import Flask


class AbstractExtension(object, metaclass=ABCMeta):
    """
    Базовый класс для расширений.

    Умееть регистрировать расширение в приложении только один раз и проверять,
    что расширение установлено в приложении.
    """

    def __init__(self, app):
        # type: (Flask) -> None
        if not hasattr(app, 'extensions'):
            app.extensions = {}

        if self.extension_name() not in app.extensions:
            app.extensions[self.extension_name()] = self

            self._setup_extension(app)

    @classmethod
    def extension_name(cls):
        return cls.__module__ + '#' + cls.__name__

    @classmethod
    def is_setup(cls):
        return (
                hasattr(current_app, 'extensions') and
                cls.extension_name() in current_app.extensions
        )

    @abstractmethod
    def _setup_extension(self, app):
        # type: (Flask) -> None
        raise NotImplementedError
