from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.directory_logging.http_requests_logger import HttpRequestLogService


def request(method, url, **kwargs):
    log_record = HttpRequestLogService.start(method, url, kwargs.get('headers'))
    try:
        response = getattr(app.requests, method)(url=url, **kwargs)
        log_record.finish(response)
    except Exception as e:
        log_record.error(e)
        raise

    return response
