

import datetime
from decimal import Decimal
from json import JSONEncoder, loads
from uuid import UUID

from frozendict import frozendict
from uuid import UUID


class CustomJSONEncoder(JSONEncoder):
    def default(self, obj):
        if isinstance(obj, datetime.datetime):
            return obj.isoformat()
        elif isinstance(obj, datetime.date):
            return obj.isoformat()
        elif isinstance(obj, frozendict):
            return dict(obj)
        elif isinstance(obj, datetime.timedelta):
            return (datetime.datetime.min + obj).time().isoformat()
        elif isinstance(obj, Decimal):
            return float(obj)
        elif isinstance(obj, UUID):
            return str(obj)
        return super(CustomJSONEncoder, self).default(obj)


def dumps(obj, *args, **kwargs):
    kwargs.setdefault('indent', 4)
    encoder = CustomJSONEncoder(*args, **kwargs)
    return encoder.encode(obj)
