# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.models.organization import organization_type

STRING = {'type': 'string'}
STRING_OR_NULL = {'type': ['string', 'null']}

BOOLEAN = {'type': 'boolean'}

I18N_STRING = {
    'type': 'object',
    'properties': {
        'ru': STRING,
        'en': STRING,
    }
}

# этот тип, такой же, как I18N_STRING,
# только у него должен быть задан хотя бы один из ключей
I18N_STRING_REQUIRED = I18N_STRING.copy()
I18N_STRING_REQUIRED['anyOf'] = [
    {'required': [lang]}
    for lang in I18N_STRING['properties']
]

I18N_STRING_OR_NULL = I18N_STRING.copy()
I18N_STRING_OR_NULL['type'] = ['object', 'null']

INTEGER = {'type': 'integer'}
INTEGER_OR_NULL = {'type': ['integer', 'null']}
LIST_OF_INTEGERS = {
    'type': 'array',
    'items': INTEGER
}

NUMBER = {'type': 'number'}
NUMBER_OR_NULL = {'type': ['number', 'null']}

DATE = {
    'type': 'string',
    'format': 'date',
    'pattern': '^\d{4}-\d{2}-\d{2}$'
}
DATE_OR_NULL = DATE.copy()
DATE_OR_NULL['type'] = ['string', 'null']

DATETIME = {
    'type': 'string',
    'format': 'date-time',
    'pattern': '^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{6}Z$'
}
# Название организации должно содержать как минимум один символ
# Префикс (?u) задаёт Unicode режим работы.
# Без него \w не матчится на русские символы.
ORG_NAME_STRING = {
    'type': 'string',
    'minLength': 1,
    'maxLength': 200,
}
ORG_TYPES_ENUM = {
    'enum': organization_type.all_types,
}
LABEL_STRING = {
    'type': 'string',
    'pattern': '^\w[-\w]+\w$',
}
DOMAIN_STRING = {
    'type': 'string',
    'pattern': '/^[a-zA-Z0-9._-]+\\[a-zA-Z0-9.-]$/',
}
LIST_OF_DOMAINS = {
    'type': 'array',
    'items': DOMAIN_STRING,
}

STRING_OR_INTEGER = {
    "anyOf": [
        STRING,
        INTEGER
    ]
}

GENDER_TYPE = {
    'anyOf': [
        {'enum': ['male', 'female']},
        {'type': 'null'},
    ]
}

BILLING_PERSON_TYPE = {
    'enum': ['natural', 'legal'],
}

BILLING_SUBSCRIPTION_PLAN_TYPE = {
    'enum': ['paid', 'free'],
}

BILLING_CURRENCY_TYPE = {
    'enum': ['RUB'],
}

LIST_OF_STRINGS = {
    'type': 'array',
    'items': STRING,
}

MAIL_PROTOCOL = {
    'enum': ['imap', 'pop3'],
}


EMAIL_STRING = {
    'type': 'string',
    'pattern': '^.+@.+\..+$'
}

LIST_OF_EMAILS = {
    'type': 'array',
    'items': EMAIL_STRING,
    'minItems': 1,
    'maxItems': 50,
    'uniqueItems': True,
}


def replace_i18n_strings_in_schema(schema):
    result = schema.copy()
    def replace(value):
        if value == I18N_STRING:
            return STRING
        if value == I18N_STRING_REQUIRED:
            return STRING
        if value == I18N_STRING_OR_NULL:
            return STRING_OR_NULL
        return value

    if 'properties' in result:
        result['properties'] = dict(
            (key, replace(value))
            for key, value in list(result['properties'].items())
        )
    return result
