# -*- coding: utf-8 -*-
import datetime

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.utils import (
    url_join,
    utcnow,
)
from intranet.yandex_directory.src.yandex_directory.common import http_client


class STEPApiClient(object):
    def __init__(self):
        self.api_url = app.config['STEP_API']
        self.token = app.config['STEP_TOKEN']
        self.headers = {
            "Authorization": "OAuth {}".format(self.token),
            "Сontent-type": "application/json"
        }

    def create_cluster_table_publish_events(self, table):
        now_date = utcnow()
        timestamp = now_date.strftime('%Y-%m-%dT00:00:00')
        for_date = now_date.strftime('%Y-%m-%d')
        path = '//home/yandex-connect/prod/analytics/{table}/' + for_date

        events = [{
            'name': 'cluster_table_publish',
            'params': {
                'scale': '1d',
                'cluster': 'hahn',
                'type': 'yandex-connect',
                'timestamp': timestamp,
                'path': path.format(table=table),
                'group': 'analytics_{table}'.format(table=table),
            }
        }]
        return self._create_events(events)

    def _create_events(self, events):
        # https://wiki.yandex-team.ru/statbox/infrastructure/doc/api/#sozdatsobytija
        url = url_join(self.api_url, 'api/v1/events')
        data = {
            'events': events,
        }
        return self._make_post_request(url, data)

    def _make_post_request(self, url, data):
        response = http_client.request('post', url, json=data, headers=self.headers)
        json_response = response.json()
        return json_response
