# coding: utf-8

from collections import namedtuple
from contextlib import contextmanager
from flask import g
from magic_repr import make_repr


Node = namedtuple('Node', ['type', 'name', 'data'])


@contextmanager
def trace_node(type, name):
    node = Node(
        type=type,
        name=name,
        data=[],
    )
    if getattr(g, 'trace_nodes', None):
        g.trace_nodes[-1].data.append(node)
        g.trace_nodes.append(node)
    else:
        g.trace_nodes = [node]

    yield node

    # по завершении, снимаем ноду со стека
    g.trace_nodes.pop()


def trace_data(node, data):
    node.data.append(data)


def print_node(node):
    print(make_repr()(node))
