import ssl

import grpc
from intranet.yandex_directory.src import settings
from yc_as_client.client import YCAccessServiceClient

from intranet.yandex_directory.src.yandex_directory.directory_logging.http_requests_logger import grpc_logging
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.connect_services.cloud.service_account import get_cert


class CloudAccessServiceClient:
    def __init__(self):
        self._host = settings.CLOUD_ACCESS_SERVICE_HOST
        self._creds = None

    def _get_creds(self):
        if not self._creds:
            host, port = self._host.split(':')
            self._creds = grpc.ssl_channel_credentials(get_cert(host=host, port=port))

        return self._creds

    def get_cloud_uid_by_iam_token(self, iam_token):
        with grpc.secure_channel(self._host, self._get_creds()) as channel,\
             grpc_logging(self._host, 'YCAccessServiceClient_Authenticate'):
            account = YCAccessServiceClient(channel, timeout=app.config['CLOUD_ACCESS_SERVICE_TIMEOUT']).authenticate(iam_token)
            return account
