from intranet.yandex_directory.src import settings
import time
import jwt
import urllib.parse

from yandex.cloud.priv.iam.v1 import iam_token_service_pb2_grpc
from yandex.cloud.priv.iam.v1 import iam_token_service_pb2

import grpc
import ssl

from intranet.yandex_directory.src.yandex_directory.directory_logging.http_requests_logger import grpc_logging
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


def get_service_token_by_uid(uid):
    """
    Получаем IAM token по uid пользователя, используем если
    в запросе явно не передали X-USER-IAM-TOKEN
    """
    pass


def get_cert(host, port):
    if settings.CLOUD_USE_LOCAL_SERT:
        try:
            cert = _read_root_certificates()
        except FileNotFoundError:
            log.error('Not found cloud certificates on file system')
            cert = ssl.get_server_certificate((host, port)).encode('utf-8')
    else:
        cert = ssl.get_server_certificate((host, port)).encode('utf-8')
    return cert


def _read_root_certificates():
    with open(settings.CLOUD_DEFAULT_CA_PATH, "rb") as f:
        certs = f.read()
    return certs


def get_service_token():
    full_host = settings.CLOUD_TS_HOST
    host, port = full_host.split(':')
    creds = grpc.ssl_channel_credentials(get_cert(host=host, port=port))
    jwt_token = _get_jwt_token()

    with grpc.secure_channel(full_host, creds) as channel,\
         grpc_logging(full_host, 'IamTokenServiceStub_Create'):
        stub = iam_token_service_pb2_grpc.IamTokenServiceStub(channel)
        grpc_response = stub.Create(
            iam_token_service_pb2.CreateIamTokenRequest(
                jwt=jwt_token,
            ),
            timeout=app.config['CLOUD_TS_TIMEOUT']
        )
        iam_token = grpc_response.iam_token

    return iam_token


def _get_jwt_token():
    now = int(time.time())
    payload = dict(
        aud=urllib.parse.urljoin(settings.CLOUD_IAM_HOST, 'v1/tokens'),
        iss=settings.CLOUD_SERVICE_ACCOUNT_ID,
        iat=now,
        exp=now + 360,
    )

    return jwt.encode(
        payload,
        settings.CLOUD_PRIVATE_KEY.encode('ascii'),
        algorithm='PS256',
        headers={'kid': settings.CLOUD_KEY},
    )
