# coding: utf-8
from intranet.yandex_directory.src.yandex_directory.common.exceptions import ServiceNotFound
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from . import (
    metrika,
    direct,
    yandexsprav,
)

_services = {
    'metrika': metrika.Service,
    'direct': direct.Service,
    'yandexsprav': yandexsprav.Service,
}


def get_service(slug):
    try:
        return _services[slug]()
    except KeyError:
        with log.fields(service_slug=slug):
            raise ServiceNotFound()


def permissions_for_resource_access(main_connection, uid, org_id, object_type, object_id, **kwargs):
    try:
        service = get_service(object_type)
    except ServiceNotFound:
        return False

    return service.has_change_permission_for_resource(
        main_connection=main_connection,
        uid=uid,
        resource_id=object_id,
        org_id=org_id,
    )
