# coding: utf-8
from intranet.yandex_directory.src.yandex_directory.common.db import get_meta_connection
from intranet.yandex_directory.src.yandex_directory.connect_services.idm import base_service
from intranet.yandex_directory.src.yandex_directory.connect_services.idm.exceptions import ClientIDBoundError
from intranet.yandex_directory.src.yandex_directory.core.models import ResourceModel, OrganizationServiceModel, ServiceModel
from intranet.yandex_directory.src.yandex_directory.connect_services.direct.base import check_if_already_has_association


class Service(base_service.ConnectService):
    responsible_relation = '/user/chief/'

    @property
    def service_slug(self):
        return 'direct'

    def request_roles(self, org_id, author_id, *roles):
        for role in roles:
            if role.get('user_type', 'user') != 'user':
                continue
            if check_if_already_has_association(role['uid'], role['resource_id']):
                raise ClientIDBoundError()

        return super(Service, self).request_roles(org_id, author_id, *roles)

    def change_responsible(self, main_connection, org_id, author_id, responsible_id):
        resources = ResourceModel(main_connection).filter(
            org_id=org_id,
            service=self.service_slug,
        ).all()

        for resource in resources:
            if check_if_already_has_association(responsible_id, resource['external_id']):
                raise ClientIDBoundError()

        with get_meta_connection() as meta_connection:
            service_id = ServiceModel(meta_connection).get_by_slug(self.service_slug)['id']

        old_responsible_uid = OrganizationServiceModel(main_connection).filter(
            org_id=org_id, service_id=service_id,
        ).one()['responsible_id']

        old_roles = self.idm_system_provider.get_active_user_roles(
            org_id=org_id,
            author_id=author_id,
            uid=[old_responsible_uid, responsible_id]
        )

        if old_roles:
            old_roles_ids = [
                old_role['id']
                for old_role in old_roles
            ]

            self.idm_system_provider.revoke_roles(
                org_id,
                author_id,
                None,
                *old_roles_ids
            )

        roles = []

        for resource in resources:
            roles.append({
                'uid': responsible_id,
                'path': '/user/employee/',
                'user_type': 'user',
                'resource_id': resource['external_id'],
            })

            roles.append({
                'uid': responsible_id,
                'path': '/user/chief/',
                'user_type': 'user',
                'resource_id': resource['external_id'],
            })

        self.idm_system_provider.request_roles(org_id, author_id, *roles)

    def has_change_permission_for_resource(self, main_connection, uid, resource_id, org_id):
        """
        Сейчас права директа может редактировать только chief,
        а он является ответственным за организацию и поэтому до этой
        проверки очередь не доходит, а для всех других нужно просто вернуть False
        """
        return False
