# coding: utf-8

from intranet.yandex_directory.src.yandex_directory.common.exceptions import APIError


class IDMError(APIError):
    code = 'idm.external_service_error'
    message = 'External service error acquired'
    description = 'Внутренняя ошибка IDM'


class OperationNotInIdmError(Exception):
    """
    Эта ошибка должна перехватываться вьюхами.
    Если она произошла - значит хождение в IDM для данного
    сервиса не реализовано и следует использовать код который
    не работает с IDM (то есть работает с ролями в нашей базе)
    """


class ClientIDBoundError(APIError):
    status_code = 422
    code = 'another_client_id_is_already_bound'
    message = 'User had already been bounded with another client_id'
    description = 'Пользователь уже связан с другим client_id'
