# coding: utf-8

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log
from intranet.yandex_directory.src.yandex_directory.core.task_queue import Task
from intranet.yandex_directory.src.yandex_directory.core.models import (
    ResourceRelationModel,
    UserServiceLicenseExternalData,
    ServiceModel,
)
from intranet.yandex_directory.src.yandex_directory.core.models.service import update_service_licenses


class PartnerDiskTask(Task):
    need_rollback = True

    def __init__(self, *args, **kwargs):
        super(PartnerDiskTask, self).__init__(*args, **kwargs)
        self.service_id = ServiceModel(self.main_connection).filter(slug='disk').one()['id']


class AddSpacePartnerDiskTask(PartnerDiskTask):
    """
    Выдаем пользователю место в партнерском диске
    """

    def do(self, org_id, uid, resource_id, author_id):
        # сначала проверим, что лицензия действительно есть в базе,
        # вдруг её успели удалить
        if not ResourceRelationModel(self.main_connection).filter(
                resource_id=resource_id,
                org_id=org_id,
                user_id=uid,
        ).count():
            log.info('Disk license for uid does not exists')
            return

        user_service_external_data = UserServiceLicenseExternalData(self.main_connection)
        if user_service_external_data.filter(
                org_id=org_id,
                user_id=uid,
                service_id=self.service_id
        ).one():
            log.info('Disk space already added in this org')
            return

        response = app.partner_disk.add_disk_space(uid)
        UserServiceLicenseExternalData(self.main_connection).create(
            org_id=org_id,
            user_id=uid,
            service_id=self.service_id,
            external_data={'service_id': response['service_id']}
        )

    def rollback(self, org_id, uid, resource_id, author_id):
        # если выдать место в диске не удалось, удалим лицензию из базы
        ResourceRelationModel(self.main_connection).delete(dict(
            resource_id=resource_id,
            org_id=org_id,
            user_id=uid,
        ))
        update_service_licenses(self.main_connection, org_id, 'disk', author_id)


class DeleteSpacePartnerDiskTask(PartnerDiskTask):
    """
    Отбираем место в партнерском диске
    """

    def do(self, org_id, uid, resource_id, author_id):
        # если лицензия есть в базе, то отбирать место не будем
        if ResourceRelationModel(self.main_connection).filter(
                resource_id=resource_id,
                org_id=org_id,
                user_id=uid,
        ).count():
            log.info('Disk license for uid exists')
            return

        user_service_external_data = UserServiceLicenseExternalData(self.main_connection)
        user_service_data = user_service_external_data.filter(
            org_id=org_id,
            user_id=uid,
            service_id=self.service_id
        ).one()
        if not user_service_data:
            log.info('Disk space already deleted in this org')
            return

        app.partner_disk.delete_disk_space(uid, user_service_data['external_data']['service_id'])
        user_service_external_data.delete(dict(
            org_id=org_id,
            user_id=uid,
            service_id=self.service_id,
        ))

    def rollback(self, org_id, uid, resource_id, author_id):
        # если удалить место в диске не удалось, вернем лицензию в базу
        ResourceRelationModel(self.main_connection).create(
            resource_id=resource_id,
            org_id=org_id,
            user_id=uid,
            name='member',
        )
        update_service_licenses(self.main_connection, org_id, 'disk', author_id)
