# -*- coding: utf-8 -*-
from intranet.yandex_directory.src import settings

from intranet.yandex_directory.src.yandex_directory.core.task_queue import Task
from intranet.yandex_directory.src.yandex_directory import app

from intranet.yandex_directory.src.yandex_directory.core.models import ResourceModel
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_main_connection,
    get_shard_numbers,
)
from intranet.yandex_directory.src.yandex_directory.core.actions import action_resource_delete
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


class CheckMetrikaResourcesTask(Task):
    singleton = True
    tries = 5
    org_id_is_required = False

    def do(self):
        """
        Проверяем не удалились ли счетчики из метрики которые есть в нашей базе
        если удалились - удаляем и у нас тоже
        """
        shards = get_shard_numbers()
        for shard in shards:
            with get_main_connection(for_write=True, shard=shard) as main_connection:
                resources_in_db = (ResourceModel(main_connection)
                                   .filter(service=settings.METRIKA_SERVICE_SLUG)
                                   .fields('id', 'external_id', 'org_id')
                                   )

                external_ids = [resource['external_id'] for resource in resources_in_db]
                existing_counters = app.metrika.get_existing_counters(*external_ids)
                resources_to_delete = [
                    resource for resource in resources_in_db
                    if resource['external_id'] not in existing_counters
                ]
                if resources_to_delete:
                    self.delete_resources(main_connection, resources_to_delete)

    def delete_resources(self, main_connection, resources_to_delete):
        ResourceModel(main_connection).delete(
            filter_data={
                'id': [resource['id'] for resource in resources_to_delete],
                'service': settings.METRIKA_SERVICE_SLUG,
            }
        )
        for resource in resources_to_delete:
            resource_data = {
                'id': resource['id'],
                'external_id': resource['external_id'],
                'service': settings.METRIKA_SERVICE_SLUG,
            }
            with log.fields(resource={
                'id': resource['external_id'],
                'service': {
                    'slug': settings.METRIKA_SERVICE_SLUG,
                },
            }):
                action_resource_delete(
                    main_connection,
                    org_id=resource['org_id'],
                    author_id=None,
                    object_value=resource_data,
                    old_object=resource_data,
                )
