# coding: utf-8
from intranet.yandex_directory.src import settings

from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.exceptions import UnknownService


ROLES = {
    'monetization': [
        {
            'slug': 'view_monetization',
            'name': {
                'ru': 'Просмотр с монетизацией',
                'en': 'Read with monetization',
            },
        },
    ],
    'no_monetization': [
        {
            'slug': 'edit',
            'name': {
                'ru': 'Редактирование',
                'en': 'Editing',
            },
        },
        {
            'slug': 'view',
            'name': {
                'ru': 'Просмотр',
                'en': 'Read',
            },
        },
    ],
}

DIRECT_ROLES = [{
    'slug': '/user/employee/',
    'name': {
        'ru': 'Представитель',
        'en': 'Representative',
    },
}]

ALICE_ROLES = [
    {
        'slug': 'edit',
        'name': {
            'ru': 'Добавление и удаление устройств',
            'en': 'Add or remove devices',
        },
    },
    {
        'slug': 'status',
        'name': {
            'ru': 'Управление статусом устройств',
            'en': 'Control device status',
        },
    },
    {
        'slug': 'view',
        'name': {
            'ru': 'Просмотр списка устройств',
            'en': 'View device list',
        },
    },
    {
        'slug': 'promocode',
        'name': {
            'ru': 'Использование промо-кодов',
            'en': 'Apply promocodes',
        },
    },
]


def get_service_roles(service_slug, **kwargs):
    if service_slug == settings.METRIKA_SERVICE_SLUG:
        resource_id = kwargs['resource_id']

        has_monetization = app.metrika.is_counters_has_monetization(resource_id)[resource_id]

        if has_monetization:
            return ROLES['monetization'] + ROLES['no_monetization']
        else:
            return ROLES['no_monetization']

    if service_slug == settings.DIRECT_SERVICE_SLUG:
        return DIRECT_ROLES

    if service_slug == settings.ALICE_SERVICE_SLUG:
        return ALICE_ROLES

    raise UnknownService(service_slug=service_slug)
