# -*- coding: utf-8 -*-
from flask import g

from intranet.yandex_directory.src.yandex_directory.core.models.action import ActionModel
from intranet.yandex_directory.src.yandex_directory.common.trace import trace_node, trace_data
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


def get_action_type(action_name):
    """
    Тип объекта определяется первым словом названия события. Например
    user для user_added
    """
    return action_name.split('_')[0]


def save_action(main_connection,
                org_id,
                author_id,
                object_value,
                old_object=None,
                name=None,
                content=None):
    with log.fields(action={'name': name}):
        # Иногда в тестах возникает циклический импорт
        from intranet.yandex_directory.src.yandex_directory.core.events.base import yield_events
        object_type = get_action_type(name)

        action = ActionModel(main_connection).create(
            org_id,
            name,
            author_id,
            object_value,
            object_type,
            old_object,
        )
        g.revision = action['revision']
        log.info('Create action: "{}"'.format(name))

        # для генерации документации по действиям, сохраним
        # объект в данный нам список
        with trace_node('action', name) as node:
            trace_data(node, action)
            # TODO: Надо это дальше порефакторить.
            #       Зачем нам content с одним единственным "before"?
            if not content and old_object:
                content = {'before': old_object}

            yield_events(
                main_connection,
                name,
                org_id,
                g.revision,
                object_value,
                object_type=object_type,
                content=content,
                author_id=author_id,
            )
            return g.revision


def def_action(name):
    """Возвращает функцию, которая принимает набор полей
    и сохраняет "действие" в базу.
    """
    def run(*args, **kwargs):
        kwargs['name'] = name
        return save_action(*args, **kwargs)
    return run
