# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.events import (
    event_domain_added,
    event_domain_deleted,
    event_domain_master_changed,
    event_domain_occupied,
    event_domain_alienated,
)
from intranet.yandex_directory.src.yandex_directory.core.events.utils import (
    get_content_object,
)
from intranet.yandex_directory.src.yandex_directory.common.models.types import (
    TYPE_DOMAIN,
)
from intranet.yandex_directory.src.yandex_directory.core.utils.domain import domain_is_tech


def set_domain_tech_field(domain):
    domain['tech'] = domain_is_tech(domain['name'])
    return domain


def on_domain_add(main_connection, org_id, revision, object_value, object_type, content, author_id, **kwargs):
    """
    Обработчик действия "добавление домена".
    Args:
        org_id (int): id организации
        revision (int): номер ревизии
        object_value (object): словарь с параметрами домена
        content (object): по ключу before объект до изменений
    """
    set_domain_tech_field(object_value)

    diff = {} # для добавления и удаления diff пустой

    content = get_content_object(diff=diff)

    event_domain_added(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=TYPE_DOMAIN,
        content=content,
        author_id=author_id,
    )


def on_domain_delete(main_connection, org_id, revision, object_value, object_type, content, author_id, **kwargs):
    """
    Обработчик действия "удаление домена".
    Args:
        org_id (int): id организации
        revision (int): номер ревизии
        object_value (object): словарь с параметрами домена
        content (object): по ключу before объект до изменений
    """
    set_domain_tech_field(object_value)

    diff = {} # для добавления и удаления diff пустой

    content = get_content_object(diff=diff)

    event_domain_deleted(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=TYPE_DOMAIN,
        content=content,
        author_id=author_id,
    )


def on_domain_master_modify(connection, org_id, revision, object_value, object_type, content, author_id, **kwargs):
    """
    Обработчик действия "смена мастер-домена".
    Args:
        org_id (int): id организации
        revision (int): номер ревизии
        object_value (object): объект после изменений
        content (object): по ключу before объект до изменений
    """
    set_domain_tech_field(object_value)
    if content:
        set_domain_tech_field(content['before'])

    diff = {
        'before': content['before'] if content else None,
        'after':  object_value
    }

    content = get_content_object(diff=diff)
    event_domain_master_changed(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
        author_id=author_id,
    )


def on_domain_occupy(main_connection, org_id, revision, object_value, object_type, content, author_id, **kwargs):
    """
    Обработчик действия "подтверждения домена".
    Args:
        org_id (int): id организации
        revision (int): номер ревизии
        object_value (object): словарь с параметрами домена
        content (object): по ключу before объект до изменений
    """
    set_domain_tech_field(object_value)

    diff = {} # для добавления и удаления diff пустой

    content = get_content_object(diff=diff)

    event_domain_occupied(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=TYPE_DOMAIN,
        content=content,
        author_id=author_id,
    )


def on_domain_alienate(main_connection, org_id, revision, object_value, object_type, content, author_id, **kwargs):
    """
    Обработчик действия "отчуждения домена".
    Args:
        org_id (int): id организации
        revision (int): номер ревизии
        object_value (object): словарь с параметрами домена
        content (object): по ключу before объект до изменений
    """
    set_domain_tech_field(object_value)

    diff = {} # для добавления и удаления diff пустой

    content = get_content_object(diff=diff)

    event_domain_alienated(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=TYPE_DOMAIN,
        content=content,
        author_id=author_id,
    )
