# -*- coding: utf-8 -*-


from intranet.yandex_directory.src.yandex_directory.core.events import (
    event_group_added,
    event_group_property_changed,
    event_group_membership_changed,
    event_group_deleted,
    event_group_alias_added,
    event_group_alias_deleted,
)
from intranet.yandex_directory.src.yandex_directory.core.events.group import _get_add_remove_members

from intranet.yandex_directory.src.yandex_directory.core.events.utils import (
    get_content_object,
)


def on_group_add(connection,
                 org_id,
                 revision,
                 group,
                 object_type,
                 **kwargs):
    """
    Обработчик действия: добавление группы.
    """
    event_group_added(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=group,
        object_type=object_type,
    )


def on_group_modify(connection,
                    org_id,
                    revision,
                    group,
                    object_type,
                    content,
                    **kwargs):
    """
    Обработчик действия: группа как-то изменилась.
    1. Генерируем событие 'group_membership_changed'.
    2. Генерируем событие 'group_property_changed'.
    """
    old_group = content.get('before', {})
    both = set(group.keys()) & set(old_group.keys())
    diff = {k: (old_group[k], group[k]) for k in both if old_group[k] != group[k]}

    if 'members_count' in diff:
        diff.pop('members_count')
    if 'admins' in diff:
        # т.к. про админов генерируем отдельное действие
        diff.pop('admins')
    if 'members' in diff:
        members_before, members_after = diff.pop('members')
        diff_members = {
            'members': _get_add_remove_members(members_before, members_after),
        }
        content = get_content_object(diff=diff_members)
        event_group_membership_changed(
            connection,
            org_id=org_id,
            revision=revision,
            object_value=group,
            object_type=object_type,
            content=content,
        )

    if diff:
        content = get_content_object(
            diff=diff,
        )
        event_group_property_changed(
            connection,
            org_id=org_id,
            revision=revision,
            object_value=group,
            object_type=object_type,
            content=content,
        )


def on_group_delete(connection,
                    org_id,
                    revision,
                    group,
                    object_type,
                    **kwargs):
    """
    Обработчик действия удаления группы.
    Генерируем событие 'group_deleted'.
    """
    event_group_deleted(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=group,
        object_type=object_type,
        save_after_notification=True,
    )


def on_group_alias_add(connection,
                       org_id,
                       revision,
                       object_value,
                       object_type,
                       content,
                       **kwargs):
    event_group_alias_added(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content
    )


def on_group_alias_delete(connection,
                          org_id,
                          revision,
                          object_value,
                          object_type,
                          content,
                          **kwargs):
    event_group_alias_deleted(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content
    )
