# coding: utf-8
from retrying import retry

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log

from intranet.yandex_directory.src.yandex_directory.core.events import (
    event_organization_added,
    event_service_enabled,
    event_service_disabled,
    event_service_ready,
    event_organization_subscription_plan_changed,
    event_organization_promocode_activated,
    event_organization_promocode_deactivated,
    event_organization_deleted,
    event_organization_type_changed,
    event_organization_outer_deputy_added,
    event_organization_outer_deputy_deleted,
    event_organization_owner_changed,
    event_organization_blocked,
    event_organization_unblocked,
)

from intranet.yandex_directory.src.yandex_directory.core.utils.tasks import CreateRobotTask
from intranet.yandex_directory.src.yandex_directory.core.events.utils import notify_callback


def on_organization_add(main_connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия "Добавлена оганизация"
    """
    event_organization_added(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content={},
    )


def on_service_enable(main_connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия "Сервис добавлен в организацию"
    """
    event_service_enabled(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content={
            'slug': object_value['slug'],
            'name': object_value['name'],
            'responsible_id': object_value['responsible_id'],
        },
    )
    if object_value['robot_required']:
        CreateRobotTask(main_connection).delay(
            service_slug=object_value['slug'],
            org_id=org_id,
        )


def on_service_disable(main_connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия "Сервис отключен в организации"
    """
    event_service_disabled(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content={
            'slug': object_value['slug'],
            'name': object_value['name'],
        },
    )


def on_service_set_ready(main_connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия "Сервис готов"
    """
    event_service_ready(
        main_connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content={
            'slug': object_value['slug'],
            'name': object_value['name'],
        },
    )


def on_organization_subscription_plan_change(connection,
                                             org_id,
                                             revision,
                                             object_value,
                                             object_type,
                                             content,
                                             **kwargs):
    """
    Обработчик действия смены тарифного плана.
    """
    event_organization_subscription_plan_changed(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
        save_after_notification=True,
    )


def on_organization_promocode_activate(connection,
                                       org_id,
                                       revision,
                                       object_value,
                                       object_type,
                                       content,
                                       **kwargs):
    """
    Обработчик действия активации промокода
    """
    event_organization_promocode_activated(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_organization_promocode_deactivate(connection,
                                         org_id,
                                         revision,
                                         object_value,
                                         object_type,
                                         content,
                                         **kwargs):
    """
    Обработчик действия деактивации промокода
    """
    event_organization_promocode_deactivated(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_organization_delete(connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия удаления организации
    """
    event_organization_deleted(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_organization_type_change(connection,
                                       org_id,
                                       revision,
                                       object_value,
                                       object_type,
                                       content,
                                       **kwargs):
    """
    Обработчик действия смены типа организации
    """
    event_organization_type_changed(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )

# Временно закомментировано, пока мы не решим, какие данные
# должны быть в событии про смену логотипа:
# https://st.yandex-team.ru/DIR-3691
#
# def on_organization_logo_change(connection,
#                                 org_id,
#                                 revision,
#                                 object_value,
#                                 object_type,
#                                 content,
#                                 **kwargs):
#     """
#     Обработчик действия смены лого.
#     """
#     diff = {'before': content['before'] if content else None,
#             'after':  object_value}
#     content = get_content_object(diff=diff)

#     event_organization_logo_changed(
#         connection,
#         org_id=org_id,
#         revision=revision,
#         object_value=object_value,
#         object_type=object_type,
#         content=content,
#     )


def on_organization_outer_deputy_add(connection,
                                     org_id,
                                     revision,
                                     object_value,
                                     object_type,
                                     content,
                                     **kwargs):
    """
    Обработчик действия удаления внешнего зама
    """
    event_organization_outer_deputy_added(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_organization_outer_deputy_delete(connection,
                                        org_id,
                                        revision,
                                        object_value,
                                        object_type,
                                        content,
                                        **kwargs):
    """
    Обработчик действия добавления внешнего зама
    """
    event_organization_outer_deputy_deleted(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_organization_owner_change(connection,
                                 org_id,
                                 revision,
                                 object_value,
                                 object_type,
                                 content,
                                 **kwargs):
    """
    Обработчик действия смены типа организации
    """
    event_organization_owner_changed(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_organization_block(connection,
                          org_id,
                          revision,
                          object_value,
                          object_type,
                          content,
                          **kwargs):
    """
    Обработчик блокировки организации
    """
    event_organization_blocked(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_organization_unblock(connection,
                            org_id,
                            revision,
                            object_value,
                            object_type,
                            content,
                            **kwargs):
    """
    Обработчик разблокировки организации
    """
    event_organization_unblocked(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


# 10000 - 10 секунд
@retry(wait_exponential_multiplier=100, wait_exponential_max=2000, stop_max_delay=10000)
def _notify_organization_deleted(meta_connection, main_connection, new_events_subscribers, organization_deleted_event):
    """
    Оповещаем всех кто подписан на событие удаление организации
    """
    # в случае ошибок повторно будут оповещены все

    # тк при откате мы удаляем все из базы
    # оповестим всех подписчиков руками
    for key, events in new_events_subscribers.items():
        _, callback = key
        with log.fields(callback=callback):
            for e in events:
                try:
                    notify_callback(
                        meta_connection=meta_connection,
                        main_connection=main_connection,
                        callback=callback,
                        event=organization_deleted_event,
                        settings=e['settings'],
                    )
                    log.debug('Notified')
                except Exception:
                    log.trace().error('Error during notify callback')
                    raise
