# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.core.events import (
    event_resource_added,
    event_resource_relation_deleted,
    event_resource_relation_added,
    event_resource_modified,
    event_resource_deleted,
)

from intranet.yandex_directory.src.yandex_directory.common.models.types import (
    TYPE_RESOURCE,
    TYPE_RELATION,
)
from intranet.yandex_directory.src.yandex_directory.core.resource_history.resource import save_resource_history


def on_resource_add(connection,
                    org_id,
                    revision,
                    resource,
                    author_id,
                    **kwargs):
    save_resource_history(
        org_id=org_id,
        action='add',
        author_id=author_id,
        resource_id=resource['external_id'],
        service_slug=resource['service'],
    )
    event_resource_added(
        connection,
        org_id=org_id,
        revision=revision,
        object_value={
            'id': resource['id'],
            'external_id': resource['external_id'],
            'service': resource['service'],
        },
        object_type=TYPE_RESOURCE,
    )


def on_resource_delete(connection,
                       org_id,
                       revision,
                       resource,
                       author_id,
                       **kwargs):
    save_resource_history(
        org_id=org_id,
        action='delete',
        author_id=author_id,
        resource_id=resource['external_id'],
        service_slug=resource['service'],
    )
    event_resource_deleted(
        connection,
        org_id=org_id,
        revision=revision,
        object_value={
            'id': resource['id'],
            'external_id': resource['external_id'],
            'service': resource['service'],
        },
        object_type=TYPE_RESOURCE,
    )


def on_resource_relation_delete(
        connection,
        org_id,
        revision,
        relation,
        author_id,
        **kwargs):

    save_resource_history(
        org_id=org_id,
        action='relation_delete',
        author_id=author_id,
        resource_id=relation['resource_id'],
        service_slug=relation['service_slug'],
    )
    event_resource_relation_deleted(
        connection,
        org_id=org_id,
        revision=revision,
        object_value={
            'id': relation['id'],
            'external_id': relation['resource_id'],
        },
        object_type=TYPE_RELATION,
    )


def on_resource_relation_add(
        connection,
        org_id,
        revision,
        relation,
        author_id,
        **kwargs):

    save_resource_history(
        org_id=org_id,
        action='relation_add',
        author_id=author_id,
        resource_id=relation['resource_id'],
        service_slug=relation['service_slug'],
    )
    event_resource_relation_added(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=relation,
        object_type=TYPE_RELATION,
    )


def on_resource_modify(connection,
                    org_id,
                    revision,
                    resource,
                    author_id,
                    **kwargs):

    save_resource_history(
        org_id=org_id,
        action='modify',
        author_id=author_id,
        resource_id=resource['external_id'],
        service_slug=resource['service'],
    )
    event_resource_modified(
        connection,
        org_id=org_id,
        revision=revision,
        object_value={
            'id': resource['id'],
            'external_id': resource['external_id'],
            'service': resource['service'],
        },
        object_type=TYPE_RESOURCE,
    )


def on_resource_license_request(connection,
                                org_id,
                                revision,
                                object_value,
                                **kwargs):
    save_resource_history(
        org_id=org_id,
        action='license_request',
        author_id=object_value['author_id'],
        resource_id=object_value['external_id'],
        service_slug=object_value['service_slug'],
    )


def on_resource_license_request_action(connection,
                                       org_id,
                                       revision,
                                       object_value,
                                       author_id,
                                       **kwargs):
    save_resource_history(
        org_id=org_id,
        action='license_request_{}'.format(object_value['action']),
        author_id=author_id,
        resource_id=object_value['external_id'],
        service_slug=object_value['service_slug'],
    )
