# -*- coding: utf-8 -*-
from datetime import timedelta
from intranet.yandex_directory.src.yandex_directory.common.utils import utcnow
from intranet.yandex_directory.src.yandex_directory.core.events import (
    event_service_license_changed,
    event_service_trial_ended,
    event_service_robot_added,
    event_service_responsible_changed,
)


def on_service_license_change(connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия: изменены лицензии сервиса. Опововещаем только о факте изменения без контента
    """
    event_service_license_changed(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
        notify_at=utcnow() + timedelta(seconds=60),
    )


def on_service_trial_end(connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия: закончился триал
    """
    event_service_trial_ended(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_service_robot_add(connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия: создан робот сервиса
    """
    event_service_robot_added(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
    )


def on_service_responsible_change(connection, org_id, revision, object_value, object_type, content, **kwargs):
    """
    Обработчик действия: изменен ответственный сервиса
    """
    event_service_responsible_changed(
        connection,
        org_id=org_id,
        revision=revision,
        object_value=object_value,
        object_type=object_type,
        content=content,
        notify_at=utcnow(),
    )
