# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.core.billing.utils import save_organizations_consumed_products_to_yt
from intranet.yandex_directory.src.yandex_directory.core.task_queue import Task
from intranet.yandex_directory.src.yandex_directory.core.models.organization import (
    OrganizationBillingInfoModel,
    OrganizationLicenseConsumedInfoModel,
)


class SaveBillingInfoToYTTask(Task):
    tries = 1
    tries_delay = 10
    lock_ttl = 60
    need_rollback = False
    singleton = True
    org_id_is_required = False

    def do(self, *args, **kwargs):
        save_organizations_consumed_products_to_yt()


class CheckOrganizationBalanceTask(Task):
    singleton = False

    def do(self, org_id, **kwargs):
        OrganizationBillingInfoModel(self.main_connection).check_balance_and_debt(org_id)


class CheckOrganizationBalanceSingletonTask(CheckOrganizationBalanceTask):
    singleton = True
