# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.core.models import (
    RobotServiceModel
)
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand


class Command(AllShardsCommand):
    """
    Одноразовая команда, нужная для того, чтобы проставить всем существующим
    роботам признак, что они приняли пользовательское соглашение.

    Нужно запустить после того, как выкатится фикс:
    https://st.yandex-team.ru/DIR-3489
    """
    name = 'accept-eula-for-robots'

    def run(self):
        robots = RobotServiceModel(self.main_connection).find()
        for robot in robots:
            app.passport.accept_eula(robot['uid'])
