# -*- coding: utf-8 -*-
import sys

from intranet.yandex_directory.src.yandex_directory.common.commands.base import TransactionalCommand, Option


class Command(TransactionalCommand):
    """Эта команда запускает запрос из указанного файла
    указанное количество раз и меряет среднее время выполнения запроса.
    """
    name = 'analyze-query'

    option_list = (
        Option('--file-path', '-f', dest='file_path', required=True, help='File with SQL query'),
        Option('--meta', '-m', dest='meta', action='store_true'),
        Option('--num', '-n', dest='num', default=1000),
        Option('--dsn', '-d', dest='dsn'),
        Option('--show-results', '-r', dest='show_results', action='store_true'),
    )
    def run(self, file_path, meta=False, num=1000, dsn=None, show_results=False):
        from time import time

        if file_path == '-':
            query = sys.stdin.read()
        else:
            with open(file_path) as f:
                query = f.read()

        # direct connection
        if dsn:
            import psycopg2
            conn = psycopg2.connect(dsn)
            cursor = conn.cursor()
            execute = cursor.execute
        else:
            if meta:
                cursor = self.meta_connection.connection.cursor()
                execute = cursor.execute
            else:
                cursor = self.main_connection.connection.cursor()
                execute = cursor.execute

        if show_results:
            print(execute(query).fetchall())
        else:
            start = time()
            prev = start
            max_time = 0
            min_time = 1000
            for i in range(num):
                execute(query)
                cursor.fetchall()
                end = time()
                curr_time = end - prev
                max_time = max(max_time, curr_time)
                min_time = min(max_time, curr_time)
                prev = end
            end = time()

            print(max_time * 1000)
            print(min_time * 1000)
            print((end - start) * 1000 / num)
