# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand
from intranet.yandex_directory.src.yandex_directory.common.commands.base import Option
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_meta_connection,
    get_main_connection,
    get_shard,
)
from intranet.yandex_directory.src.yandex_directory.core.models import (
    OrganizationModel,
    UserMetaModel,
)
from intranet.yandex_directory.src.yandex_directory.core.utils import is_outer_uid


class Command(BaseCommand):
    """Смена владельца организации
    """
    name = 'change-org-admin'
    option_list = (
        Option('--org-id',  dest='org_id', type=int, required=True),
        Option('--old-admin-uid',  dest='old_admin_uid', type=int, required=True),
        Option('--new-admin-uid', dest='new_admin_uid', type=int, required=True),
    )

    def run(self, org_id, old_admin_uid, new_admin_uid):
        with get_meta_connection() as meta_connection:
            shard = get_shard(meta_connection, org_id)
        if shard is None:
            if not app.testing:
                print('Организация {} не найдена'.format(org_id))
            return False
        if not (is_outer_uid(old_admin_uid) and is_outer_uid(new_admin_uid)):
            if not app.testing:
                print('Команда работает только для передачи организации между внешними админами')
            return False

        with get_meta_connection(for_write=True) as meta_connection, \
             get_main_connection(shard, for_write=True) as main_connection:
            OrganizationModel(main_connection).update(
                update_data={'admin_uid': new_admin_uid},
                filter_data={'admin_uid': old_admin_uid, 'id': org_id}
            )

            UserMetaModel(meta_connection).update(
                update_data={
                    'id': new_admin_uid
                },
                filter_data={
                    'id': old_admin_uid,
                    'user_type': 'outer_admin',
                    'org_id': org_id,
                }
            )
        if not app.testing:
            print('Организация передана')
        return True
