# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory import app
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand
from intranet.yandex_directory.src.yandex_directory.common.commands.base import Option
from intranet.yandex_directory.src.yandex_directory.common.db import (
    get_meta_connection,
    get_main_connection,
    get_shard,
)
from intranet.yandex_directory.src.yandex_directory.core.models import (
    OrganizationModel,
)


class Command(BaseCommand):
    """
    Смена типа организации
    """
    name = 'change-org-type'
    option_list = (
        Option('--org-id',  dest='org_id', type=int, required=True),
        Option('--new-org-type', dest='new_org_type', type=str, required=True),
        Option('--client_id', dest='client_id', type=int),
        Option('--person_id', dest='person_id', type=int),
    )

    def run(self, org_id, new_org_type, client_id, person_id):
        with get_meta_connection() as meta_connection:
            shard = get_shard(meta_connection, org_id)
        if shard is None:
            if not app.testing:
                print('Организация {} не найдена'.format(org_id))
            return False

        with get_main_connection(shard, for_write=True) as main_connection:
            OrganizationModel(main_connection).change_organization_type(
                org_id,
                new_org_type,
                client_id=client_id,
                person_id=person_id,
            )
        return 'OK'
