# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log
from intranet.yandex_directory.src.yandex_directory.common.commands.base import (
    AllShardsCommand,
    Option,
)
from intranet.yandex_directory.src.yandex_directory.common.db import get_main_connection
from intranet.yandex_directory.src.yandex_directory.core.models.organization import OrganizationBillingInfoModel
from intranet.yandex_directory.src.yandex_directory.core.utils import only_attrs
from intranet.yandex_directory.src.yandex_directory.core.billing.tasks import CheckOrganizationBalanceSingletonTask


class Command(AllShardsCommand):
    name = 'check-balance-and-debt'
    option_list = (
        Option('--org-id', '-o', dest='org_id', type=int, required=False, help='Organization id.'),
        Option('--force', '-f', dest='force_update', action='store_true', required=False),
    )

    def run(self, org_id, force_update):
        if org_id:
            filter_data = {'org_id': org_id}
        else:
            filter_data = None
        org_ids = only_attrs(
            OrganizationBillingInfoModel(self.main_connection).find(
                fields=['org_id'],
                filter_data=filter_data,
            ),
            'org_id',
        )
        for org_id in org_ids:
            with get_main_connection(self.shard, for_write=True) as main_connection:
                try:
                    CheckOrganizationBalanceSingletonTask(main_connection).delay(org_id=org_id)
                except:
                    log.trace().error('Error while checking balance')
