# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.commands.base import (
    AllShardsCommand,
    Option,
)
from intranet.yandex_directory.src.yandex_directory.common.db import get_main_connection
from intranet.yandex_directory.src.yandex_directory.core.models.organization import OrganizationBillingInfoModel


class Command(AllShardsCommand):
    name = 'check-inactive-contracts'
    option_list = (
        Option('--org-id', '-o', dest='org_id', type=int, required=False, help='Organization id.'),
    )

    def run(self, org_id):
        if org_id:
            filter_data = {'org_id': org_id}
        else:
            filter_data = None
        organizations_billing_info = OrganizationBillingInfoModel(self.main_connection).find(filter_data=filter_data)
        for org_billing_info in organizations_billing_info:
            OrganizationBillingInfoModel(self.main_connection).check_contract_status_in_billing(
                org_id=org_billing_info['org_id'],
                client_id=org_billing_info['client_id']
            )
