# -*- coding: utf-8 -*-
import pprint

from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand, Option
from intranet.yandex_directory.src.yandex_directory.common.utils import get_user_data_from_blackbox_by_login
from intranet.yandex_directory.src.yandex_directory import disk


class Command(BaseCommand):
    name = 'check-user-disk'
    option_list = (
        Option('login'),
    )

    def run(self, login):
        data = get_user_data_from_blackbox_by_login(login)

        if not data:
            print('Пользователь с таким логином не найден.')
        else:
            active = disk.is_user_active(data['uid'])
            print('Диск Активирован:', 'да' if active else 'нет')
            if active:
                pprint.pprint(disk.get_user_info(data['uid']))
