# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand
from intranet.yandex_directory.src.yandex_directory.core.models.group import GroupModel
from intranet.yandex_directory.src.yandex_directory.core.models.organization import OrganizationModel


class Command(AllShardsCommand):
    """Миграция данных, для того, чтобы для каждого департамента была
    создана соответствующая ему группа руководителя.
    """
    name = 'create-group-resources'

    def run(self):
        mgroup = GroupModel(self.main_connection)
        organizations = OrganizationModel(self.main_connection).find()

        for organization in organizations:
            groups = mgroup.find(
                filter_data=dict(org_id=organization['id']),
                fields=[
                    '*',
                    'all_users.*',
                ]
            )

            for group in groups:
                if not group['resource_id'] is None:
                    return

                with self.main_connection.begin_nested():
                    relations = []

                    for user in group['all_users']:
                        relation = dict(
                            name='include',
                            user_id=user['id'],
                        )
                        relations.append(relation)

                    resource = mgroup.create_resource_for_group(
                        org_id=organization['id'],
                        relations=relations,
                    )
                    mgroup.update_one(
                        org_id=organization['id'],
                        group_id=group['id'],
                        data=dict(resource_id=resource['id']),
                    )
