# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.commands.base import BaseCommand
from intranet.yandex_directory.src.yandex_directory.core.models.department import (
    DepartmentModel, get_name_for_heads_group)
from intranet.yandex_directory.src.yandex_directory.core.models.group import GroupModel


class Command(BaseCommand):
    """Миграция данных, для того, чтобы для каждого департамента была
    создана соответствующая ему группа руководителя.
    """
    name = 'create-head-groups'

    def run(self):
        all_departments = DepartmentModel(self.main_connection).find()
        for dep in all_departments:
            if dep['heads_group_id'] is None:
                name = dep['name'].get('ru', dep['name'].get('en', ''))
                print((
                    'Creating heads group for org_id={org_id} '
                    'department_id={id} name={name}'
                ).format(
                    org_id=dep['org_id'],
                    id=dep['id'],
                    name=name.encode('utf-8')
                ))

                group = GroupModel(self.main_connection).create(
                    name=get_name_for_heads_group(dep['name']),
                    org_id=dep['org_id'],
                    type='department_head'
                )

                DepartmentModel(self.main_connection).update_one(
                    id=dep['id'],
                    org_id=dep['org_id'],
                    data={
                        'heads_group_id': group['id']
                    }
                )

        print('DONE')
