# -*- coding: utf-8 -*-

from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand
from intranet.yandex_directory.src.yandex_directory.core.models.domain import DomainModel
from intranet.yandex_directory.src.yandex_directory.core.models.organization import OrganizationModel
from intranet.yandex_directory.src.yandex_directory.core.utils import (
    create_domain_for_organization,
)
from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


class Command(AllShardsCommand):
    """
    Миграция данных, для того, чтобы для каждой организации был
    создан соответствующий домен.
    """
    name = 'create-org-domains'

    def run(self):
        organizations = OrganizationModel(self.main_connection).find()

        for organization in organizations:
            org_id = organization['id']

            with log.fields(org_id=org_id):
                domains = DomainModel(self.main_connection).find(
                    filter_data=dict(org_id=organization['id'])
                )
                if not domains and organization['label']:
                    with self.main_connection.begin_nested():
                        domain = create_domain_for_organization(
                            connection=self.main_connection,
                            organization=organization,
                            domain_part=None,
                        )
                        with log.fields(domain=domain['name']):
                            log.info('Domain was created for organization')
