# -*- coding: utf-8 -*-
import datetime
from dateutil.relativedelta import relativedelta

from intranet.yandex_directory.src.yandex_directory.core.models import (
    ServiceModel,
    OrganizationServiceModel,
    ResourceModel,
)

from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand


class Command(AllShardsCommand):
    name = 'create-resources-for-tracker'

    def run(self):
        service = ServiceModel(self.meta_connection).get_by_slug('tracker')
        org_service_model = OrganizationServiceModel(self.main_connection)
        tracker_services = org_service_model.find(filter_data={'service_id': service['id']})
        for org_service in tracker_services:
            data = {}
            if org_service['resource_id'] is None:
                resource = ResourceModel(self.main_connection).create(org_service['org_id'], 'directory')
                data['resource_id'] = resource['id']
            if org_service['ready_at']:
                data['trial_expires'] = max(
                    datetime.date(2017, 11, 30),
                    (org_service['ready_at'] + relativedelta(months=service['trial_period_months'])).date()
                )
            if data:
                org_service_model.update(
                    update_data=data,
                    filter_data={
                        'org_id': org_service['org_id'],
                        'service_id': service['id'],
                    },
                )
