# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.core.models import (
    ServiceModel,
    OrganizationServiceModel,
    OrganizationMetaModel,
)
from intranet.yandex_directory.src.yandex_directory.common.commands.base import AllShardsCommand
from intranet.yandex_directory.src.yandex_directory.core.utils.robots import get_robot_nickname
from intranet.yandex_directory.src.yandex_directory.core.utils.tasks import CreateRobotTask
from intranet.yandex_directory.src.yandex_directory.common.utils import get_user_login_from_passport_by_uid

from intranet.yandex_directory.src.yandex_directory.directory_logging.logger import log


class Command(AllShardsCommand):
    """
    Создаём роботных пользователей если это необходимо.
    """
    name = 'create-robots'

    def run(self):
        organization_meta_model = OrganizationMetaModel(self.meta_connection)
        organization_service_model = OrganizationServiceModel(self.main_connection)
        services = ServiceModel(self.meta_connection).find(
            filter_data={'robot_required': True},
        )

        for service in services:
            with log.fields(service_id=service['id']):
                if service['robot_uid']:
                    # Если сервис использует в качестве робота
                    # одну и ту же учётку, то нам надо достать её nickname
                    # из blackbox
                    robot_uid = service['robot_uid']
                    robot_nickname = get_user_login_from_passport_by_uid(robot_uid)
                    if not robot_nickname:
                        with log.fields(robot_uid=robot_uid):
                            message = 'Robot with uid not found in blackbox'
                            log.error(message)
                            raise RuntimeError(message)
                else:
                    # В противном случае - сгенерим никнейм на основе слага сервиса
                    # robot-{slug}
                    robot_nickname = get_robot_nickname(service['slug'])

                org_ids_without_robot = organization_service_model.find_organizations_without_robot(
                    service_slug=service['slug'],
                    service_id=service['id'],
                    nickname=robot_nickname,
                )
                if len(org_ids_without_robot) == 0:
                    continue

                org_ids = [x['id'] for x in organization_meta_model.find(filter_data={'id': org_ids_without_robot}, fields=['id'])]

                for org_id in org_ids:
                    CreateRobotTask(self.main_connection).delay(
                        service_slug=service['slug'],
                        org_id=org_id,
                    )
