# -*- coding: utf-8 -*-
from intranet.yandex_directory.src.yandex_directory.common.commands.base import (
    AllShardsCommand,
    Option,
)
from intranet.yandex_directory.src.yandex_directory.core.models.organization import OrganizationPromocodeModel


class Command(AllShardsCommand):
    name = 'disable-expired-promocodes'
    option_list = (
        Option('--org-id', '-o', dest='org_id', type=int, required=False, help='Organization id.'),
    )

    def run(self, org_id):
        OrganizationPromocodeModel(self.main_connection).deactivate_expired_promocodes(
            org_id=org_id,
        )


DisableExpiredPromocodesCommand = Command
